/**************************************************************************************
Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.
***************************************************************************************
$Id: EipEncap_error.h 51162 2015-01-29 10:21:28Z kai $:

Description:
  Error Codes of the EthernetIP Encapsulation task

**************************************************************************************/

#ifndef __EIP_ENCAP_ERROR_H
#define __EIP_ENCAP_ERROR_H

/////////////////////////////////////////////////////////////////////////////////////
// Ethernet/IP Encapsulation
/////////////////////////////////////////////////////////////////////////////////////
//
// MessageId: TLR_E_EIP_ENCAP_COMMAND_INVALID
//
// MessageText:
//
//  Invalid command received.
//
#define TLR_E_EIP_ENCAP_COMMAND_INVALID  ((TLR_RESULT)0xC01E0001L)

//
// MessageId: TLR_E_EIP_ENCAP_NOT_INITIALIZED
//
// MessageText:
//
//  Encapsulation layer is not initialized.
//
#define TLR_E_EIP_ENCAP_NOT_INITIALIZED  ((TLR_RESULT)0xC01E0002L)

//
// MessageId: TLR_E_EIP_ENCAP_OUT_OF_MEMORY
//
// MessageText:
//
//  System is out of memory.
//
#define TLR_E_EIP_ENCAP_OUT_OF_MEMORY    ((TLR_RESULT)0xC01E0003L)

//
// MessageId: TLR_E_EIP_ENCAP_OUT_OF_PACKETS
//
// MessageText:
//
//  Task runs out of empty packets at the local packet pool.
//
#define TLR_E_EIP_ENCAP_OUT_OF_PACKETS   ((TLR_RESULT)0xC01E0010L)

//
// MessageId: TLR_E_EIP_ENCAP_SEND_PACKET
//
// MessageText:
//
//  Sending a packet failed.
//
#define TLR_E_EIP_ENCAP_SEND_PACKET      ((TLR_RESULT)0xC01E0011L)

//
// MessageId: TLR_E_EIP_ENCAP_SOCKET_OVERRUN
//
// MessageText:
//
//  No free socket is available.
//
#define TLR_E_EIP_ENCAP_SOCKET_OVERRUN   ((TLR_RESULT)0xC01E0012L)

//
// MessageId: TLR_E_EIP_ENCAP_INVALID_SOCKET
//
// MessageText:
//
//  Socket ID is invalid.
//
#define TLR_E_EIP_ENCAP_INVALID_SOCKET   ((TLR_RESULT)0xC01E0013L)

//
// MessageId: TLR_E_EIP_ENCAP_CEP_OVERRUN
//
// MessageText:
//
//  Connection could not be open. No resource for a new Connection Endpoint available.
//
#define TLR_E_EIP_ENCAP_CEP_OVERRUN      ((TLR_RESULT)0xC01E0014L)

//
// MessageId: TLR_E_EIP_ENCAP_UCMM_OVERRUN
//
// MessageText:
//
//  Message couldn't send. All Unconnect Message Buffers are in use.
//
#define TLR_E_EIP_ENCAP_UCMM_OVERRUN     ((TLR_RESULT)0xC01E0015L)

//
// MessageId: TLR_E_EIP_ENCAP_TRANSP_OVERRUN
//
// MessageText:
//
//  Connection couldn't be opened. All transports are in use.
//
#define TLR_E_EIP_ENCAP_TRANSP_OVERRUN   ((TLR_RESULT)0xC01E0016L)

//
// MessageId: TLR_E_EIP_ENCAP_UNKNOWN_CONN_TYP
//
// MessageText:
//
//  Received Message include an unknown connection typ.
//
#define TLR_E_EIP_ENCAP_UNKNOWN_CONN_TYP ((TLR_RESULT)0xC01E0017L)

//
// MessageId: TLR_E_EIP_ENCAP_CONN_CLOSED
//
// MessageText:
//
//  Connection was closed.
//
#define TLR_E_EIP_ENCAP_CONN_CLOSED      ((TLR_RESULT)0xC01E0000L)

//
// MessageId: TLR_E_EIP_ENCAP_CONN_RESETED
//
// MessageText:
//
//  Connection is reseted from remote device.
//
#define TLR_E_EIP_ENCAP_CONN_RESETED     ((TLR_RESULT)0xC01E0019L)

//
// MessageId: TLR_S_EIP_ENCAP_CONN_UNREGISTER
//
// MessageText:
//
//  We closed the conncetion successful. With an unregister command.
//
#define TLR_S_EIP_ENCAP_CONN_UNREGISTER  ((TLR_RESULT)0x001E001AL)

//
// MessageId: TLR_E_EIP_ENCAP_CONN_STATE
//
// MessageText:
//
//  Wrong connection state for this service.
//
#define TLR_E_EIP_ENCAP_CONN_STATE       ((TLR_RESULT)0xC01E001BL)

//
// MessageId: TLR_E_EIP_ENCAP_CONN_INACTIV
//
// MessageText:
//
//  Encapsulation sesson was deactivated
//
#define TLR_E_EIP_ENCAP_CONN_INACTIV     ((TLR_RESULT)0xC01E001CL)

//
// MessageId: TLR_E_EIP_ENCAP_INVALID_IPADDR
//
// MessageText:
//
//  received an invalid IP address.
//
#define TLR_E_EIP_ENCAP_INVALID_IPADDR   ((TLR_RESULT)0xC01E001DL)

//
// MessageId: TLR_E_EIP_ENCAP_INVALID_TRANSP
//
// MessageText:
//
//  Invalid transport typ.
//
#define TLR_E_EIP_ENCAP_INVALID_TRANSP   ((TLR_RESULT)0xC01E001EL)

//
// MessageId: TLR_E_EIP_ENCAP_TRANSP_INUSE
//
// MessageText:
//
//  Transport is still in use.
//
#define TLR_E_EIP_ENCAP_TRANSP_INUSE     ((TLR_RESULT)0xC01E001FL)

//
// MessageId: TLR_E_EIP_ENCAP_TRANSP_CLOSED
//
// MessageText:
//
//  Transport is closed.
//
#define TLR_E_EIP_ENCAP_TRANSP_CLOSED    ((TLR_RESULT)0xC01E0020L)

//
// MessageId: TLR_E_EIP_ENCAP_INVALID_MSGID
//
// MessageText:
//
//  The received message has a invalid message ID.
//
#define TLR_E_EIP_ENCAP_INVALID_MSGID    ((TLR_RESULT)0xC01E0021L)

//
// MessageId: TLR_E_EIP_ENCAP_INVALID_MSG
//
// MessageText:
//
//  invalid encapsulation message received.
//
#define TLR_E_EIP_ENCAP_INVALID_MSG      ((TLR_RESULT)0xC01E0022L)

//
// MessageId: TLR_E_EIP_ENCAP_INVALID_MSGLEN
//
// MessageText:
//
//  Received message with invalid length.
//
#define TLR_E_EIP_ENCAP_INVALID_MSGLEN   ((TLR_RESULT)0xC01E0023L)

//
// MessageId: TLR_E_EIP_ENCAP_CL3_TIMEOUT
//
// MessageText:
//
//  Class 3 connection runs into timeout.
//
#define TLR_E_EIP_ENCAP_CL3_TIMEOUT      ((TLR_RESULT)0xC01E0030L)

//
// MessageId: TLR_E_EIP_ENCAP_UCMM_TIMEOUT
//
// MessageText:
//
//  Unconnected message gets a timeout.
//
#define TLR_E_EIP_ENCAP_UCMM_TIMEOUT     ((TLR_RESULT)0xC01E0031L)

//
// MessageId: TLR_E_EIP_ENCAP_CL1_TIMEOUT
//
// MessageText:
//
//  Timeout of a class 3 connection.
//
#define TLR_E_EIP_ENCAP_CL1_TIMEOUT      ((TLR_RESULT)0xC01E0032L)

//
// MessageId: TLR_W_EIP_ENCAP_TIMEOUT
//
// MessageText:
//
//  Encapsulation service is finished by timeout.
//
#define TLR_W_EIP_ENCAP_TIMEOUT          ((TLR_RESULT)0x801E0033L)

//
// MessageId: TLR_E_EIP_ENCAP_CMDRUNNING
//
// MessageText:
//
//  Encapsulation service is still running.
//
#define TLR_E_EIP_ENCAP_CMDRUNNING       ((TLR_RESULT)0xC01E0034L)

//
// MessageId: TLR_E_EIP_ENCAP_NO_TIMER
//
// MessageText:
//
//  No empty timer available.
//
#define TLR_E_EIP_ENCAP_NO_TIMER         ((TLR_RESULT)0xC01E0035L)

//
// MessageId: TLR_E_EIP_ENCAP_INVALID_DATA_IDX
//
// MessageText:
//
//  The data index is unknown by the task. Please ensure that it is the same as at the indication.
//
#define TLR_E_EIP_ENCAP_INVALID_DATA_IDX ((TLR_RESULT)0xC01E0036L)

//
// MessageId: TLR_E_EIP_ENCAP_INVALID_DATA_AREA
//
// MessageText:
//
//  The parameter of the data area are invalid. Please check length and offset.
//
#define TLR_E_EIP_ENCAP_INVALID_DATA_AREA ((TLR_RESULT)0xC01E0037L)

//
// MessageId: TLR_E_EIP_ENCAP_INVALID_DATA_LEN
//
// MessageText:
//
//  Packet length is invalid. Please check length of the packet.
//
#define TLR_E_EIP_ENCAP_INVALID_DATA_LEN ((TLR_RESULT)0xC01E0038L)

//
// MessageId: TLR_E_EIP_ENCAP_TASK_RESETING
//
// MessageText:
//
//  Ethernet/IP Encapsulation Layer runs a reset.
//
#define TLR_E_EIP_ENCAP_TASK_RESETING    ((TLR_RESULT)0xC01E0039L)

//
// MessageId: TLR_E_EIP_ENCAP_DUPLICATE_SERVICE
//
// MessageText:
//
//  The service is rejected by the application due to a duplicate sequence count.
//
#define TLR_E_EIP_ENCAP_DUPLICATE_SERVICE ((TLR_RESULT)0xC01E003AL)


#endif  //__EIP_ENCAP_ERROR_H

